#include "stdafx.h"
#include "win_demo.h"
#include "DialogThermalParam.h"
#include "afxdialogex.h"
#include "common_struct.h"
#include "sdks.h"
#include "perser_json.h"
#include "pack_json.h"

IMPLEMENT_DYNAMIC(CDialogThermalParam, CDialogEx)
extern int m_handle;
extern int m_chn_option;
CDialogThermalParam::CDialogThermalParam(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_THERMAL_PARAM, pParent)
{

}

CDialogThermalParam::~CDialogThermalParam()
{
}

void CDialogThermalParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_TEMPERATURE_UNIT, m_tempera_unit);
	DDX_Control(pDX, IDC_COMBO_DISTANCE_UNIT, m_length_unit);
	DDX_Control(pDX, IDC_CHECK_OPEN_TEMPERA, m_open_tempera);
	DDX_Control(pDX, IDC_EDIT_ENV_TEMPERA_C, m_env_tempera_c);
	DDX_Control(pDX, IDC_EDIT_ENV_TEMPERA_F, m_env_tempera_f);
	DDX_Control(pDX, IDC_EDIT_TEMPERATURE_C, m_cav_tempera_c);
	DDX_Control(pDX, IDC_EDIT_TEMPERATURE_F, m_cav_tempera_f);
	DDX_Control(pDX, IDC_EDIT_DISTANCE_M, m_distance_m);
	DDX_Control(pDX, IDC_EDIT_DISTANCE_FT, m_distance_ft);
	DDX_Control(pDX, IDC_EDIT_THRESHOLD, m_threshold);
	DDX_Control(pDX, IDC_EDIT_PHYSICS_INFO, m_physics_info);
	DDX_Control(pDX, IDC_EDIT_TEMP_ALARM_INT, m_alarm_int);
	DDX_Control(pDX, IDC_EDIT_NORMAL_TEMP_MIN_C, m_nor_tempera_min_c);
	DDX_Control(pDX, IDC_EDIT_NORMAL_TEMP_MIN_F, m_nor_tempera_min_f);
	DDX_Control(pDX, IDC_EDIT_NORMAL_TEMP_MAX_C, m_nor_tempera_max_c);
	DDX_Control(pDX, IDC_EDIT_NORMAL_TEMP_MAX_F, m_nor_tempera_max_f);
	DDX_Control(pDX, IDC_COMBO_MEASURE_MODE, m_measure_mode);
	DDX_Control(pDX, IDC_COMBO_FONTSIZE_MODE, m_fontsize_mode);

	DDX_Control(pDX, IDC_COMBO_AREA_ID, m_area_id);
	DDX_Control(pDX, IDC_COMBO_ALARM_TYPE, m_alarm_type);
	DDX_Control(pDX, IDC_COMBO_AREA_SHAPE_TYPE, m_shape_type);
	DDX_Control(pDX, IDC_EDIT_AREA_NAME, m_area_name);
	DDX_Control(pDX, IDC_EDIT_ALARM_MAX, m_alarm_max);
	DDX_Control(pDX, IDC_EDIT_WARRING_ALARM, m_warring_alarm);
	DDX_Control(pDX, IDC_EDIT_EMISSIVITY, m_emissivity);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X1, m_point_x1);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y1, m_point_y1);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X2, m_point_x2);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y2, m_point_y2);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X3, m_point_x3);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y3, m_point_y3);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X4, m_point_x4);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y4, m_point_y4);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X5, m_point_x5);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y5, m_point_y5);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X6, m_point_x6);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y6, m_point_y6);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X7, m_point_x7);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y7, m_point_y7);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_X8, m_point_x8);
	DDX_Control(pDX, IDC_EDIT_AREA_POINT_Y8, m_point_y8);
}

jy_dev_thermal_cap_t thermal_cap_info = { 0 };
jy_dev_thermal_param_t thermal_param_info = { 0 };
BOOL CDialogThermalParam::OnInitThermalParam()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_dev_get_thermal_cap(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		json_perser_thermal_cap(p_result, &thermal_cap_info);
	}
	if (thermal_cap_info.is_thermal)
	{
		nRet = sdks_get_thermal_param(m_handle, m_chn_option, &p_result);
		if (0 == nRet)
		{
			json_perser_thermal_param(p_result, &thermal_param_info);
			((CButton*)GetDlgItem(IDC_CHECK_OPEN_TEMPERA))->SetCheck(0);
			if (thermal_param_info.is_open_tempera_measure)
			{
				((CButton*)GetDlgItem(IDC_CHECK_OPEN_TEMPERA))->SetCheck(1);
			}
			m_tempera_unit.InsertString(0, TEXT("Celsius"));
			m_tempera_unit.InsertString(1, TEXT("Fahrenheit"));
			m_tempera_unit.SetCurSel(thermal_param_info.tempera_unit);
			m_length_unit.InsertString(0, TEXT("Meter"));
			m_length_unit.InsertString(1, TEXT("Feet"));
			m_length_unit.SetCurSel(thermal_param_info.length_unit);
			(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_C)->ShowWindow(FALSE);
			(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_F)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_C)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_F)->ShowWindow(FALSE);
			(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_C)->ShowWindow(FALSE);
			(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_F)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_C)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_F)->ShowWindow(FALSE);
			(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_M)->ShowWindow(FALSE);
			(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_FT)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_LENGTH_M)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_LENGTH_FT)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_C)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_F)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_C)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_F)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_C)->ShowWindow(FALSE);
			(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_F)->ShowWindow(FALSE);
			((CButton*)GetDlgItem(IDC_CHECK_FACECOLOR_ENABLE))->SetCheck(0);
			if (thermal_param_info.facecolor_enable)
			{
				((CButton*)GetDlgItem(IDC_CHECK_FACECOLOR_ENABLE))->SetCheck(1);
			}
			((CButton*)GetDlgItem(IDC_CHECK_AVE_TEMPERA))->SetCheck(0);
			if (thermal_param_info.ave_tempera_corre)
			{
				((CButton*)GetDlgItem(IDC_CHECK_AVE_TEMPERA))->SetCheck(1);
			}
			((CButton*)GetDlgItem(IDC_CHECK_ABNORMAL_TEMPERA))->SetCheck(0);
			if (thermal_param_info.abnormal_tempera_filter)
			{
				((CButton*)GetDlgItem(IDC_CHECK_ABNORMAL_TEMPERA))->SetCheck(1);
			}
			strins.Format(_T("%f"), thermal_param_info.threshold);
			m_threshold.SetWindowTextA(strins);
			strins.Format(_T("%f"), thermal_param_info.physics_info);
			m_physics_info.SetWindowTextA(strins);
			strins.Format(_T("%d"), thermal_param_info.alarm_int);
			m_alarm_int.SetWindowTextA(strins);
			m_measure_mode.InsertString(0, TEXT("Unknown"));
			m_measure_mode.InsertString(1, TEXT("Model1"));
			m_measure_mode.InsertString(2, TEXT("Model2"));
			if (thermal_param_info.measure_mode >= 0)
			{
				m_measure_mode.SetCurSel(thermal_param_info.measure_mode + 1);
			}
			else 
			{
				m_measure_mode.SetCurSel(0);
			}
			m_fontsize_mode.InsertString(0, TEXT("Small"));
			m_fontsize_mode.InsertString(1, TEXT("Middle"));
			m_fontsize_mode.InsertString(2, TEXT("Large"));
			m_fontsize_mode.SetCurSel(thermal_param_info.fontsize_mode - 1);
			OnCbnSelchangeComboTemperatureUnit();
			OnCbnSelchangeComboDistanceUnit();
		}
	}
	else
	{
		m_open_tempera.EnableWindow(FALSE);
		m_tempera_unit.EnableWindow(FALSE);
		m_length_unit.EnableWindow(FALSE);
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogThermalParam, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_TEMPERATURE_UNIT, &CDialogThermalParam::OnCbnSelchangeComboTemperatureUnit)
	ON_CBN_SELCHANGE(IDC_COMBO_DISTANCE_UNIT, &CDialogThermalParam::OnCbnSelchangeComboDistanceUnit)
	ON_BN_CLICKED(IDOK_SET_TEMP_PARAM, &CDialogThermalParam::OnBnClickedSetTempParam)
	ON_CBN_SELCHANGE(IDC_COMBO_AREA_ID, &CDialogThermalParam::OnCbnSelchangeComboAreaId)
	ON_CBN_SELCHANGE(IDC_COMBO_AREA_SHAPE_TYPE, &CDialogThermalParam::OnCbnSelchangeComboAreaShapeType)
	ON_BN_CLICKED(IDOK, &CDialogThermalParam::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogThermalParam::OnCbnSelchangeComboTemperatureUnit()
{
	float env_tempera_c = 0;
	float env_tempera_f = 0;
	float cav_tempera_c = 0;
	float cav_tempera_f = 0;
	float nor_tempera_min_c = 0;
	float nor_tempera_min_f = 0;
	float nor_tempera_max_c = 0;
	float nor_tempera_max_f = 0;
	CString strins;
	if (0 == thermal_param_info.tempera_unit)
	{
		env_tempera_c = thermal_param_info.envit_tempera;
		env_tempera_f = ((thermal_param_info.envit_tempera * 1.8) + 32);
		cav_tempera_c = thermal_param_info.cavity_tempera;
		cav_tempera_f = ((thermal_param_info.cavity_tempera * 1.8) + 32);
		nor_tempera_min_c = thermal_param_info.normal_temp_range_min;
		nor_tempera_min_f = ((thermal_param_info.normal_temp_range_min * 1.8) + 32);
		nor_tempera_max_c = thermal_param_info.normal_temp_range_max;
		nor_tempera_max_f = ((thermal_param_info.normal_temp_range_max * 1.8) + 32);
	}
	else if (1 == thermal_param_info.tempera_unit)
	{
		env_tempera_f = thermal_param_info.envit_tempera;
		env_tempera_c = ((thermal_param_info.envit_tempera - 32) / 1.8);
		cav_tempera_f = thermal_param_info.cavity_tempera;
		cav_tempera_c = ((thermal_param_info.cavity_tempera - 32) / 1.8);
		nor_tempera_min_f = thermal_param_info.normal_temp_range_min;
		nor_tempera_min_c = ((thermal_param_info.normal_temp_range_min - 32) / 1.8);
		nor_tempera_max_f = thermal_param_info.normal_temp_range_max;
		nor_tempera_max_c = ((thermal_param_info.normal_temp_range_max - 32) / 1.8);
	}
	int index_tmp = m_tempera_unit.GetCurSel();
	if (0 == index_tmp)
	{
		(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_C)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_C)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_F)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_F)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_C)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_C)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_F)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_F)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_C)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_C)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_C)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_F)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_F)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_F)->ShowWindow(FALSE);
		strins.Format(_T("%f"), env_tempera_c);
		m_env_tempera_c.SetWindowTextA(strins);
		strins.Format(_T("%f"), cav_tempera_c);
		m_cav_tempera_c.SetWindowTextA(strins);
		strins.Format(_T("%f"), nor_tempera_min_c);
		m_nor_tempera_min_c.SetWindowTextA(strins);
		strins.Format(_T("%f"), nor_tempera_max_c);
		m_nor_tempera_max_c.SetWindowTextA(strins);
	}
	else if (1 == index_tmp)
	{
		(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_C)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_C)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_TEMPERATURE_F)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_TEMPERATURE_F)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_C)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_C)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_ENV_TEMPERA_F)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_ENV_TEMPERA_F)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_F)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_F)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_F)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MIN_C)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_NORMAL_TEMP_MAX_C)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_NORMAL_TEMPERA_C)->ShowWindow(FALSE);
		strins.Format(_T("%f"), env_tempera_f);
		m_env_tempera_f.SetWindowTextA(strins);
		strins.Format(_T("%f"), cav_tempera_f);
		m_cav_tempera_f.SetWindowTextA(strins);
		strins.Format(_T("%f"), nor_tempera_min_f);
		m_nor_tempera_min_f.SetWindowTextA(strins);
		strins.Format(_T("%f"), nor_tempera_max_f);
		m_nor_tempera_max_f.SetWindowTextA(strins);
	}
}


void CDialogThermalParam::OnCbnSelchangeComboDistanceUnit()
{
	float distance_m = 0;
	float distance_ft = 0;
	CString strins;
	if (0 == thermal_param_info.length_unit)//m 1m = 3.280839ft
	{
		distance_m = thermal_param_info.distance;
		distance_ft = (thermal_param_info.distance * 3.280839);
	}
	else if (1 == thermal_param_info.length_unit)//feet
	{
		distance_ft = thermal_param_info.distance;
		distance_m = (thermal_param_info.distance / 3.280839);
	}
	int index_tmp = m_length_unit.GetCurSel();
	if (0 == index_tmp)
	{
		(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_M)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_STATIC_LENGTH_M)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_FT)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_STATIC_LENGTH_FT)->ShowWindow(FALSE);
		strins.Format(_T("%f"), distance_m);
		m_distance_m.SetWindowTextA(strins);
	}
	else if (1 == index_tmp)
	{
		(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_M)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_STATIC_LENGTH_M)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_DISTANCE_FT)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_STATIC_LENGTH_FT)->ShowWindow(TRUE);
		strins.Format(_T("%f"), distance_ft);
		m_distance_ft.SetWindowTextA(strins);
	}
}

void CDialogThermalParam::OnBnClickedSetTempParam()
{
	CDialogEx::OnOK();
	int index_tmp = 0;
	char *p_param = NULL;
	CString str_tmp;
	thermal_param_info.is_open_tempera_measure = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_OPEN_TEMPERA))->GetCheck() == TRUE)
	{
		thermal_param_info.is_open_tempera_measure = 1;
	}
	thermal_param_info.facecolor_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_FACECOLOR_ENABLE))->GetCheck() == TRUE)
	{
		thermal_param_info.facecolor_enable = 1;
	}
	thermal_param_info.abnormal_tempera_filter = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_ABNORMAL_TEMPERA))->GetCheck() == TRUE)
	{
		thermal_param_info.abnormal_tempera_filter = 1;
	}
	thermal_param_info.ave_tempera_corre = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_AVE_TEMPERA))->GetCheck() == TRUE)
	{
		thermal_param_info.ave_tempera_corre = 1;
	}
	index_tmp = m_tempera_unit.GetCurSel();
	if (0 == index_tmp)
	{
		thermal_param_info.tempera_unit = 0;
		m_cav_tempera_c.GetWindowText(str_tmp);
		thermal_param_info.cavity_tempera = _ttoi(str_tmp);
		m_env_tempera_c.GetWindowText(str_tmp);
		thermal_param_info.envit_tempera = _ttoi(str_tmp);
		m_nor_tempera_min_c.GetWindowText(str_tmp);
		thermal_param_info.normal_temp_range_min = _ttoi(str_tmp);
		m_nor_tempera_max_c.GetWindowText(str_tmp);
		thermal_param_info.normal_temp_range_max = _ttoi(str_tmp);
	}
	else
	{
		thermal_param_info.tempera_unit = 1;
		m_cav_tempera_f.GetWindowText(str_tmp);
		thermal_param_info.cavity_tempera = _ttoi(str_tmp);
		m_env_tempera_f.GetWindowText(str_tmp);
		thermal_param_info.envit_tempera = _ttoi(str_tmp);
		m_nor_tempera_min_f.GetWindowText(str_tmp);
		thermal_param_info.normal_temp_range_min = _ttoi(str_tmp);
		m_nor_tempera_max_f.GetWindowText(str_tmp);
		thermal_param_info.normal_temp_range_max = _ttoi(str_tmp);
	}
	index_tmp = m_length_unit.GetCurSel();
	if (0 == index_tmp)
	{
		thermal_param_info.length_unit = 0;
		m_distance_m.GetWindowText(str_tmp);
		thermal_param_info.distance = _ttoi(str_tmp);
	}
	else
	{
		thermal_param_info.length_unit = 1;
		m_distance_ft.GetWindowText(str_tmp);
		thermal_param_info.distance = _ttoi(str_tmp);
	}
	m_threshold.GetWindowText(str_tmp);
	thermal_param_info.threshold = _ttoi(str_tmp);
	m_physics_info.GetWindowText(str_tmp);
	thermal_param_info.physics_info = _ttoi(str_tmp);
	m_alarm_int.GetWindowText(str_tmp);
	thermal_param_info.alarm_int = _ttoi(str_tmp);
	index_tmp = m_measure_mode.GetCurSel();//m_fontsize_mode
	thermal_param_info.measure_mode = m_measure_mode.GetCurSel() - 1;
	thermal_param_info.fontsize_mode = m_fontsize_mode.GetCurSel() + 1;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set basic thermal imaging parameters?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_thermal_param(&thermal_param_info, &p_param);
		int nRet = sdks_set_thermal_param(m_handle, m_chn_option, p_param);
		if (nRet) {
			MessageBoxA("Set thermal param fail!");
		}
	}
}

jy_dev_thermal_area_measure_t thermal_area_measure;
BOOL CDialogThermalParam::OnInitThermalArea()
{
	char *p_result = NULL;
	char *p_thermal_param = NULL;
	CString strins;
	int nRet = 0;
	jy_dev_thermal_area_tempera_param_t thermal_area_param;
	thermal_area_param.area_size = 0;
	thermal_area_param.chn_id = m_chn_option;
	thermal_area_param.area_oper_type = 3;
	thermal_area_param.value = 0;
	pack_json_thermal_area_param(&thermal_area_param, &p_thermal_param);
	nRet = sdks_get_thermal_area_temperature_measure(m_handle, p_thermal_param, &p_result);
	if (0 == nRet)
	{
		json_perser_thermal_area_measure(p_result, &thermal_area_measure);
		for (int i = 0; i < thermal_area_measure.area_size; ++i)
		{
			strins.Format(_T("%d"), thermal_area_measure.area_info_list[i].area_id);
			m_area_id.InsertString(i, strins);
		}
		m_area_id.SetCurSel(0);
	}
	m_alarm_type.InsertString(0, TEXT("Temperature alarm"));
	m_alarm_type.InsertString(1, TEXT("Threshold alarm"));
	m_shape_type.InsertString(0, TEXT("Point"));
	m_shape_type.InsertString(1, TEXT("Line"));
	m_shape_type.InsertString(2, TEXT("Rectangular"));
	m_shape_type.InsertString(3, TEXT("Polygon"));
	OnCbnSelchangeComboAreaId();
	return TRUE;
}

void CDialogThermalParam::OnCbnSelchangeComboAreaId()
{
	CString strins;
	CString str_point_x;
	CString str_point_y;
	int area_id_index = m_area_id.GetCurSel();
	for (int i = 0; i < thermal_area_measure.area_size; ++i)
	{
		if (area_id_index == thermal_area_measure.area_info_list[i].area_id)
		{
			m_area_name.SetWindowTextA(thermal_area_measure.area_info_list[i].area_name);
			((CButton*)GetDlgItem(IDC_CHECK_ALARM_ENABLE))->SetCheck(0);
			if (thermal_area_measure.area_info_list[i].alarm_enable_flag)
			{
				((CButton*)GetDlgItem(IDC_CHECK_ALARM_ENABLE))->SetCheck(1);
			}
			m_alarm_type.SetCurSel(thermal_area_measure.area_info_list[i].alarm_type);
			strins.Format(_T("%d"), thermal_area_measure.area_info_list[i].alarm_max_value);
			m_alarm_max.SetWindowTextA(strins);
			strins.Format(_T("%d"), thermal_area_measure.area_info_list[i].warning_alarm_value);
			m_warring_alarm.SetWindowTextA(strins);
			((CButton*)GetDlgItem(IDC_CHECK_AREA_OPEN_FLAG))->SetCheck(0);
			if (thermal_area_measure.area_info_list[i].area_en_flag)
			{
				((CButton*)GetDlgItem(IDC_CHECK_AREA_OPEN_FLAG))->SetCheck(1);
			}
			strins.Format(_T("%f"), thermal_area_measure.area_info_list[i].emissivity);
			m_emissivity.SetWindowTextA(strins);
			m_shape_type.SetCurSel(thermal_area_measure.area_info_list[i].area_shape_type - 1);
			for (int j = 0; j < thermal_area_measure.area_info_list[i].area_point_list.list_size; ++j)
			{
				str_point_x.Format(_T("%lf"), thermal_area_measure.area_info_list[i].area_point_list.area_point[j].point_x);
				str_point_y.Format(_T("%lf"), thermal_area_measure.area_info_list[i].area_point_list.area_point[j].point_y);
				if (0 == j)
				{
					m_point_x1.SetWindowTextA(str_point_x);
					m_point_y1.SetWindowTextA(str_point_y);
				}
				else if (1 == j)
				{
					m_point_x2.SetWindowTextA(str_point_x);
					m_point_y2.SetWindowTextA(str_point_y);
				}
				else if (2 == j)
				{
					m_point_x3.SetWindowTextA(str_point_x);
					m_point_y3.SetWindowTextA(str_point_y);
				}
				else if (3 == j)
				{
					m_point_x4.SetWindowTextA(str_point_x);
					m_point_y4.SetWindowTextA(str_point_y);
				}
				else if (4 == j)
				{
					m_point_x5.SetWindowTextA(str_point_x);
					m_point_y5.SetWindowTextA(str_point_y);
				}
				else if (5 == j)
				{
					m_point_x6.SetWindowTextA(str_point_x);
					m_point_y6.SetWindowTextA(str_point_y);
				}
				else if (6 == j)
				{
					m_point_x7.SetWindowTextA(str_point_x);
					m_point_y7.SetWindowTextA(str_point_y);
				}
				else if (7 == j)
				{
					m_point_x8.SetWindowTextA(str_point_x);
					m_point_y8.SetWindowTextA(str_point_y);
				}
			}
		}
	}
	OnCbnSelchangeComboAreaShapeType();
}

void CDialogThermalParam::OnCbnSelchangeComboAreaShapeType()
{
	int shape_type_index = m_shape_type.GetCurSel() + 1;
	if (shape_type_index == 1)		//point
	{
		(CStatic *)GetDlgItem(IDC_STATIC_POINT1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y1)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT2)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X2)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y2)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT3)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X3)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y3)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT4)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X4)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y4)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y5)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y6)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y7)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y8)->ShowWindow(FALSE);
	}
	else if (shape_type_index == 2)	//line
	{
		(CStatic *)GetDlgItem(IDC_STATIC_POINT1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y1)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y2)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT3)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X3)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y3)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT4)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X4)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y4)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y5)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y6)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y7)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y8)->ShowWindow(FALSE);
	}
	else if (shape_type_index == 3)	//rectangular
	{
		(CStatic *)GetDlgItem(IDC_STATIC_POINT1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y1)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y2)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT3)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X3)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y3)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT4)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X4)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y4)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X5)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y5)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X6)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y6)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X7)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y7)->ShowWindow(FALSE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X8)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y8)->ShowWindow(FALSE);
	}
	else if (shape_type_index == 4)	//polygon
	{
		(CStatic *)GetDlgItem(IDC_STATIC_POINT1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X1)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y1)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X2)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y2)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT3)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X3)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y3)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT4)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X4)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y4)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT5)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X5)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y5)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT6)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X6)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y6)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT7)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X7)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y7)->ShowWindow(TRUE);
		(CStatic *)GetDlgItem(IDC_STATIC_POINT8)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_X8)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_AREA_POINT_Y8)->ShowWindow(TRUE);
	}
}

void CDialogThermalParam::OnBnClickedOk()
{
	CString str_tmp;
	CString str_point_x;
	CString str_point_y;
	char *p_param = NULL;
	CDialogEx::OnOK();
	//int index_tmp = 0;
	int area_id_index = m_area_id.GetCurSel();
	thermal_area_measure.area_oper_type = 1;
	thermal_area_measure.chn_id = m_chn_option;
	for (int i = 0; i < thermal_area_measure.area_size; ++i)
	{
		if (area_id_index == thermal_area_measure.area_info_list[i].area_id)
		{
			m_area_name.GetWindowText(str_tmp);
			strcpy(thermal_area_measure.area_info_list[i].area_name, str_tmp);
			thermal_area_measure.area_info_list[i].alarm_enable_flag = 0;
			if (((CButton*)GetDlgItem(IDC_CHECK_ALARM_ENABLE))->GetCheck() == TRUE)
			{
				thermal_area_measure.area_info_list[i].alarm_enable_flag = 1;
			}
			thermal_area_measure.area_info_list[i].alarm_type = m_alarm_type.GetCurSel();
			m_alarm_max.GetWindowText(str_tmp);
			thermal_area_measure.area_info_list[i].alarm_max_value = _ttoi(str_tmp);
			m_warring_alarm.GetWindowText(str_tmp);
			thermal_area_measure.area_info_list[i].warning_alarm_value = _ttoi(str_tmp);
			m_emissivity.GetWindowText(str_tmp);
			thermal_area_measure.area_info_list[i].emissivity = _ttof(str_tmp);
			thermal_area_measure.area_info_list[i].area_en_flag = 0;
			if (((CButton*)GetDlgItem(IDC_CHECK_AREA_OPEN_FLAG))->GetCheck() == TRUE)
			{
				thermal_area_measure.area_info_list[i].area_en_flag = 1;
			}
			thermal_area_measure.area_info_list[i].area_shape_type = m_shape_type.GetCurSel() + 1;
			thermal_area_measure.area_info_list[i].area_point_list.list_size = 0;
			m_point_x1.GetWindowText(str_point_x);
			m_point_y1.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[0].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[0].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x2.GetWindowText(str_point_x);
			m_point_y2.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[1].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[1].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x3.GetWindowText(str_point_x);
			m_point_y3.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[2].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[2].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x4.GetWindowText(str_point_x);
			m_point_y4.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[3].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[3].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x5.GetWindowText(str_point_x);
			m_point_y5.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[4].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[4].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x6.GetWindowText(str_point_x);
			m_point_y6.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[5].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[5].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x7.GetWindowText(str_point_x);
			m_point_y7.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[6].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[6].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			m_point_x8.GetWindowText(str_point_x);
			m_point_y8.GetWindowText(str_point_y);
			if ((_T("") != str_point_x) && (_T("") != str_point_y))
			{
				thermal_area_measure.area_info_list[i].area_point_list.area_point[7].point_x = _ttof(str_point_x);
				thermal_area_measure.area_info_list[i].area_point_list.area_point[7].point_y = _ttof(str_point_y);
				++thermal_area_measure.area_info_list[i].area_point_list.list_size;
			}
			UINT i = 0;
			i = MessageBoxA(_T("Are you sure you want to set up the thermal imaging measurement?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
			if (IDYES == i)
			{
				pack_json_thermal_area_measure(&thermal_area_measure, &p_param);
				int nRet = sdks_set_thermal_area_temperature_measure(m_handle, p_param);
				if (nRet) {
					MessageBoxA("Failed to set thermal area measure fail!");
				}
			}
		}
	}
}
